<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('appointment_reports', function (Blueprint $table) {
            $table->dropForeign(['appointment_id']);
        });

        DB::statement('ALTER TABLE appointment_reports MODIFY appointment_id BIGINT UNSIGNED NULL');

        Schema::table('appointment_reports', function (Blueprint $table) {
            $table->foreign('appointment_id')->references('id')->on('appointments')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('appointment_reports', function (Blueprint $table) {
            $table->dropForeign(['appointment_id']);
        });

        DB::table('appointment_reports')->whereNull('appointment_id')->delete();

        DB::statement('ALTER TABLE appointment_reports MODIFY appointment_id BIGINT UNSIGNED NOT NULL');

        Schema::table('appointment_reports', function (Blueprint $table) {
            $table->foreign('appointment_id')->references('id')->on('appointments')->cascadeOnDelete();
        });
    }
};
