<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\StockItem;

class StockController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    public function index()
    {
        return StockItem::orderBy('name')->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'sku' => 'nullable|string|max:255',
            'quantity' => 'required|integer',
            'purchase_price' => 'nullable|numeric',
            'sale_price' => 'nullable|numeric',
            'notes' => 'nullable|string',
        ]);

        $item = StockItem::create($data);
        return response()->json($item, 201);
    }

    public function show($id)
    {
        return StockItem::findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $item = StockItem::findOrFail($id);
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'sku' => 'nullable|string|max:255',
            'quantity' => 'required|integer',
            'purchase_price' => 'nullable|numeric',
            'sale_price' => 'nullable|numeric',
            'notes' => 'nullable|string',
        ]);

        $item->update($data);
        return response()->json($item);
    }

    public function destroy($id)
    {
        $item = StockItem::findOrFail($id);
        $item->delete();
        return response()->json(['deleted' => true]);
    }
}
